#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
import os
import glob
import time
import datetime

import recdblist
import rec10d
import os.path
import tv2mp4
def Update_to_MP4(path):
    """
    録画一時フォルダ内mp4ファイルを検索
    """
    avilist = glob.glob(path + "/*.avi")
    mkvlist = glob.glob(path+"/*.mkv")
    avilist=avilist+mkvlist
    #recdblist.printutf8(avilist)
    for avif in avilist:
        if avif.rfind("sa.avi")==-1:
            ##b25f is title.ts.b25  avi is title.avi
            dir = os.path.split(avif)[0]
            title = os.path.split(avif)[1]
            title = title.replace(".avi", "")
            title = title.replace(".mkv", "")
            avipath = os.path.join(dir, title + ".avi")
            mkvpath = os.path.join(dir, title + ".mkv")
            mp4path = os.path.join(dir, title + ".mp4")
            if not os.path.exists(mp4path):
                if os.path.exists(avipath):
                    avidtime = int(time.time()-os.path.getmtime(avipath))
                    if avidtime>300:
                        if os.path.exists(mkvpath):
                            mkvdtime = int(time.time()-os.path.getmtime(mkvpath))
                            if mkvdtime>300:
                                recdblist.printutf8(mkvpath+":"+mp4path)
                                tv2mp4.mkv2mp4(mkvpath,mp4path)
                            else:
                                recdblist.printutf8(avipath+":"+mp4path)
                                tv2mp4.avi2mp4(avipath,mp4path)
                        else:
                            recdblist.printutf8(avipath+":"+mp4path)
                            tv2mp4.avi2mp4(avipath,mp4path)
                else:
                    if not os.path.exists(avipath):
                        if os.path.exists(mkvpath):
                            mkvdtime = int(time.time()-os.path.getmtime(mkvpath))
                            if mkvdtime>300:
                                recdblist.printutf8(mkvpath+":"+mp4path)
                                tv2mp4.mkv2mp4(mkvpath,mp4path)
def auto_check(path):
    avilist = glob.glob(path + "/*.avi")
    mkvlist = glob.glob(path+"/*.mkv")
    mp4list = glob.glob(path+"/*.mp4")
    tslist = glob.glob(path+"/*.ts")
    b25list = glob.glob(path+"/*.ts.b25")
    filelist=avilist+mkvlist+tslist+b25list+mp4list
    add=[]
    tbtime=datetime.datetime.now()+datetime.timedelta(seconds=60)
    tbtime2=datetime.datetime.now()+datetime.timedelta(seconds=1200)
    for fn in filelist:
        if fn.rfind("sa.avi")==-1 and fn.rfind(".120.avi")==-1 and os.path.getsize(fn)>1*1000*1000:
            dir = os.path.split(fn)[0]
            file = os.path.split(fn)[1]
            title = os.path.splitext(file)[0]
            title = unicode(title,'utf-8')
            
            #print dbs
            ext = os.path.splitext(file)[1]
            if ext == ".b25":
                title=title.replace(".ts","")
            dbs=rec10d.rec10db.select_by_name_time_timeline(title,tbtime,tbtime2)
            if len(dbs)==0:
                proc=check_process(dir, title)
                chtxtt=rec10d.rec10db.select_chtxt_by_title_timeline_log(title)
                nchtxt=""
                if chtxtt!=None:
                    nchtxt=chtxtt
                if proc=="b25":
                    """chtxtt=rec10d.rec10db.select_chtxt_by_title_timeline_log(title)
                    nchtxt=""
                    if chtxtt!=None:
                        nchtxt=chtxtt"""
                    add.append([recdblist.REC_AUTO_SUGGEST_DECODE,title,nchtxt])
                elif proc=="ts":
                    add.append([recdblist.REC_AUTO_SUGGEST_ENCODE,title,nchtxt])
                elif proc =="avi":
                    add.append([recdblist.REC_AUTO_SUGGEST_AVI2FP,title,nchtxt])
                #elif proc =="mp4":
                #    add.append([recdblist.REC_AUTO_SUGGEST_AP2FP,title,nchtxt])
    #print add
    if len(add)>0:
        rec10d.rec10db.new_auto_proc()
        for a in add:
            rec10d.rec10db.add_auto_proc(a[0],a[1],a[2])
        time.sleep(1)
"""
    処理がどの段階まで言ったのかを調査し返す。
    return
    recording
    b25
    b25decoding
    tssplitting
    ts
    encoding
    avi
    mp4making
    mp4
"""
def check_process(path,title):
    path1 = os.path.join(path,title+".mkv")
    if os.path.exists(path1):
        if int(time.time()-os.path.getmtime(path1))>300:
            return "mkv"
        else:
            return "mkvmaking"
    elif os.path.exists(os.path.join(path,title+".mp4")):
        if int(time.time()-os.path.getmtime(os.path.join(path,title+".mp4")))>300:
            return "mp4"
        else:
            return "mp4making"
    elif os.path.exists(os.path.join(path,title+".avi")):
        if int(time.time()-os.path.getmtime(os.path.join(path,title+".avi")))>300:
            return "avi"
        else:
            return "encoding"
    elif os.path.exists(os.path.join(path,title+".ts.log")):
        if int(time.time()-os.path.getmtime(os.path.join(path,title+".ts")))<300:
            return "encoding"
        else:
            return "ts"
    elif os.path.exists(os.path.join(path,title+".ts")):
        if int(time.time()-os.path.getmtime(os.path.join(path,title+".ts")))>300:
            return "ts"
        else:
            return "tssplitting"
    elif os.path.exists(os.path.join(path,title+".sa.avi")):
        if int(time.time()-os.path.getmtime(os.path.join(path,title+".sa.avi")))>300:
            return "ts"
        else:
            return "tssplitting"
    elif os.path.exists(os.path.join(path,title+".ts.b25")):
        if int(time.time()-os.path.getmtime(os.path.join(path,title+".ts.b25")))>300:
            return "b25"
        else:
            return "recording"
    

